package jsl.fw1.engine;

/**
* This class provides a Leaf with the context it needs to
* collaborate with the rest of the framework. It's prime
* preliminary purpose is to allow a Leaf to get a reference to
* another Leaf.
*
* @author Jack Harich
*/
public class Context {

//---------- Internal Fields -------------------------------------
protected Container container;
protected String    leafName;

//---------- Initialization --------------------------------------
/**
* Creates a new instance. The container argument is required, and
* must be the container the leaf's context is in.
*/
public Context(Container container, String leafName) {
    this.container = container;
    this.leafName = leafName;
}
//---------- Public Methods --------------------------------------
/**
* Returns the named reference. Throws an IllegalArgumentException
* if not found. This method uses the References section of
* the container DK.
*/
public Object getReference(String referenceName) {
    return container.getReference(referenceName, leafName);
}
//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("Context" + text);
}

} // End class