package vcb.engine.tron;

/**
* This interface allows read only access to a Datatron entry.
* An entry has a String key, value type and value.
*
* @author Jack Harich
*/
public interface EntryReader {

//---------- Public Methods --------------------------------------
/**
* Returns the entry in a "key=value" String representation.
*/
public String toString();

/**
* Returns just the value in a String representation.
*/
public String valueToString();

/**
* Returns true if the type is String, Datatron or Object and the
* value is null or the datatron is empty. This allows an entry to
* be parsed into an empty XML value.
*/
public boolean isNull();

/**
* Determines if the entry equals another object. Returns true if
* the object is an Entry with the equivalent key, type and value.
*/
public boolean equals(Object object);

/**
* Performs a shallow copy.
*/ 
public Object clone();

/**
* Returns the key, which you should never let be null. 
* The key can be null if it was never set.
*/
public String getKey();

/**
* Returns the value type as determined by the last add or set. 
*/
public Class getType();

/**
* Returns the value as an int, performing an conversions that do
* not cause loss of data. Specifically Strings and doubles can be
* converted if they contain no fractional part. Boolean, datatron
* and Object values cannot be converted.
*/
public int getInt();

/**
* Returns the value as a double, performing conversions that do
* not cause loss of data. All ints can be converted.
* Strings can be converted if they are a valid double. Boolean,
* datatron and Object values cannot be converted.
*/
public double getDouble();

/**
* Returns the value as a boolean, performing conversions that do
* not cause loss of data. Int, double or String zeros are false.
* Int, double or String ones are true. A String "false" is false.
* A String "true" is true. Datatrons and Objects cannot be
* converted. All null values are inconvertable rather than 
* returning false.
*/
public boolean isTrue();

/**
* Returns the String representation of the value for all types.
*/
public String getString();

/**
* Returns the value as a Datatron, performing conversions that
* make sense. The only one that does is Object.
*/
public Datatron getDatatron();

/**
* Returns the value as an Object, performing conversions that
* make sense. The only ones that do are String and Datatron.
*/
public Object getObject();


} // End interface