package jsl.fw1.engine;

import vcb.engine.tron.Datatron;

/**
* A node represents an object in a tree of objects. We are using
* the Composite Pattern, with Node as the top.
* <p>
* The additional classes needed are: <pre>
* vcb.engine.tron.*, vcb.gen.util.ListOne,
* vcb.inv.core.ClassResourceReader
* </pre>
* @author Jack Harich
*/
public abstract class Node {

//---------- Internal Fields -------------------------------------
protected String    name = "Name1";
protected Container parent; // null if root
protected String    marker; // null if none

//---------- Public Methods --------------------------------------
/**
* Sets the name, which cannot be null or a zero length String.
* A name must be unique per container.
*/
public void setName(String name) {
    if (name == null) throw new IllegalArgumentException
        ("The name cannot be null.");
    if (name == "") throw new IllegalArgumentException
        ("The name cannot be a zero length String.");
    this.name = name;
}
/**
* Returns the name.
*/
public String getName() {
    return name;
}
/**
* Determines whether the node is DK driven. This version returns
* false. Subclasses should return true if DK driven. If this
* returns true then <code>setDK(Datatron dk)</code> will be called.
*/
public boolean isDKDriven() {
    return false;
}
/**
* Sets the node's DK. This is called automatically if the method
* <code>isDKDriven()</code> returns true.
*/
public void setDK(Datatron dk) {
    // Do nothing
}
/**
* Sets the node's parent.
*/
public void setParent(Container parent) {
    this.parent = parent;
}
/**
* Returns the node's parent, which is null if this is the root.
*/
public Container getParent() {
    return parent;
}
/**
* Sets the marker used to get this node's DK. A "marker" is a full
* Java class name that marks the relative location of resources
* such as DK and image files.
*/
public void setMarker(String marker) {
    this.marker = marker;
}
/**
* Returns the marker or null if none. If null is returned then the
* parent node should be checked for the marker, all the way up to
* the root node which is guarenteed to have a marker.
*/
public String getMarker() {
    return marker;
}
//---------- Protected Methods -----------------------------------

//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("Node" + text);
}

} // End class