package jsl.fw1.qc;

import jsl.fw1.engine.Container;
import jsl.fw1.engine.Node;
import java.util.Iterator;

/**
* This tests the framework using system1.
*
* @author Jack Harich
*/   // java jsl.fw1.qc.System1Test 
public class System1Test {

//---------- Internal Fields -------------------------------------

//---------- Initialization --------------------------------------
/**
* The first argument must be a marker class name to test.
*/
public static void main(String arguments[]) {
    new System1Test().runTest();
}
//---------- Public Methods --------------------------------------
/**
* Runs a simple test.
*/
public void runTest() {
    String marker = "jsl.fw1.systems.system1.System1Marker";
    Container root = Container.createRoot(marker);
    print(" - The root's name is " + root.getName());
    
    Iterator nodes = root.iterateNodes();
    while (nodes.hasNext()) {
        Node node = (Node)nodes.next();
        print(" - Node name = " + node.getName());
    }
}
//---------- Protected Methods -----------------------------------

//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("System1Test" + text);
}

} // End class