package jsl.fw1.engine;

import vcb.engine.tron.Datatron;

/**
* A node represents an object in a tree of objects. We are using
* the Composite Pattern, with Node as the top.
*
* @author Jack Harich
*/
public class Node {

//---------- Internal Fields -------------------------------------
protected String name = "Name1";

//---------- Public Methods --------------------------------------
/**
* Sets the name, which cannot be null or a zero length String.
* A name must be unique per container.
*/
public void setName(String name) {
    if (name == null) throw new IllegalArgumentException
        ("The name cannot be null.");
    if (name == "") throw new IllegalArgumentException
        ("The name cannot be a zero length String.");
    this.name = name;
}
/**
* Returns the name.
*/
public String getName() {
    return name;
}
/**
* Determines whether the node is DK driven. This version returns
* false. Subclasses should return true if DK driven. If this
* returns true then <code>setDK(Datatron dk)</code> will be called.
*/
public boolean isDKDriven() {
    return false;
}
/**
* Sets the node's DK. This is called automatically if the method
* <code>isDKDriven()</code> returns true.
*/
public void setDK(Datatron dk) {
    // Do nothing
}
//---------- Protected Methods -----------------------------------

//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("Node" + text);
}

} // End class