package org.jsl.threedoor;

/**
* This represents one symantic event in the View. It is a pure
* "data structure" class. This event is sent by
* the View to ViewListeners. All indexed collections are zero
* based.
*
* @author Tim McCauley
*/
public class ViewEvent {

//---------- Public Fields ---------------------------------------
// These are event type constants
public static final int EXIT           = 0;
public static final int START_NEW_GAME = 1;
public static final int SHOW_RESULTS   = 2;
public static final int DOOR_SELECTED  = 3;

//---------- Internal Fields -------------------------------------
protected int id;
protected int eventType;
protected int selectedDoor;

//---------- Initialization --------------------------------------
public ViewEvent(int eventType) {
    // TODO - Assert eventType is allowed
    this.eventType = eventType;
}  
//---------- Superclass Override ---------------------------------
public String toString() {
    String text = "[id=" + id + ", eventType=" + eventType +
        ", selectedDoor=" + selectedDoor;
    return text + "]";
}
//---------- Properties ------------------------------------------
//----- eventType
public int getEventType() {
    return eventType;
}
//----- id
public void setID(int id) {
    this.id = id;
}
public int getID() {
    return id;
}
//----- selectedDoor
public void setSelectedDoor(int selectedDoor) {
    this.selectedDoor = selectedDoor;
}
public int getSelectedDoor() {
    return selectedDoor;
}
//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("ViewEvent" + text);
}

} // End class