package org.jsl.threedoor;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

/**
* This class in the view in the MVC pattern. It receives
* ModelEvents and emits ViewEvents.
*
* @author Jack Harich, Tim McCauley, Cindy Nelson, Michel, etc
*/
public class View implements ModelListener, ActionListener {

//---------- Internal Fields -------------------------------------
protected Vector listeners = new Vector();   // list of ViewListeners
protected int    id;
protected int    selectedDoor; // Zero for none

// Widgets we need a reference to
protected Label[] selectedLabels = new Label[NUMBER_DOORS];
protected Label[] doorLabels     = new Label[NUMBER_DOORS];
protected TextField runningScoreTxt = new TextField();

protected Frame window = new Frame("Three Door Game");

protected static final int NUMBER_DOORS = 3;
protected static final String EXIT              = "Exit";
protected static final String SHOW_GAME_RESULTS = "ShowGameResults";
protected static final String START_NEW_GAME    = "StartNewGame";


//---------- Initialization --------------------------------------
public View() {
    // Init window
    window.setBackground(Color.lightGray);
    
    // Layout North section of window
    // Add the NUMBER_DOORS to the North panel
    Panel northPanel = new Panel();
    for (int i = 1; i <= NUMBER_DOORS; i++) {
        print(" the i = " + i);
        northPanel.add( addDoorPanel(i - 1) ); // Zero based
    }
    window.add(northPanel, "North");
    
    // Layout Center section
    Panel centerPanel = new Panel();
    centerPanel.add(createButton("Show Game Results", SHOW_GAME_RESULTS));
    centerPanel.add(new Label("Running Score"));
    centerPanel.add(runningScoreTxt);
    window.add(centerPanel, "Center");
    
    // Layout South section
    Panel southPanel = new Panel();
    southPanel.add(createButton("Start New Game", START_NEW_GAME));
    southPanel.add(createButton("Exit", EXIT));
    window.add(southPanel, "South");
    
    // Done
    window.pack();
}
/**
* This is the unit test.
*/
public static void main(String args[]) {
    View view = new View();
    view.setVisible(true);
    view.selectedLabels[2].setText("Selected");
    view.runningScoreTxt.setText("23");
}
//---------- ModelListener Implementation ------------------------
public void processModelEvent(ModelEvent evt) {
    // Check ID
    if (id != evt.getID()) {
        print(".processModelEvent() - the id's are not equal.");
    }
    // Show selected door
    // First erase all
    for (int i = 0; i < NUMBER_DOORS; i++) {
        selectedLabels[i].setText("");
    }   
    selectedDoor = 0;
    if (evt.getSelectedDoor() > 0) {
        selectedLabels[evt.getSelectedDoor()].setText("Selected");
        selectedDoor = evt.getSelectedDoor();
    }
    // Show opened doors, disable buttons for open doors
    for (int i = 0; i < NUMBER_DOORS; i++) {
        String text = "";
        if (evt.isDoorOpen(i)) {
            // Open
            text = (evt.getCarDoor() == i ? "CAR" : "Goat");
        }             
        doorLabels[i].setText(text);
    }
    // Update the running score
    runningScoreTxt.setText("" + evt.getRunningScore());
}
//---------- ActionListener Implementation -----------------------
public void actionPerformed(ActionEvent evt) {
    print(".processActionEvent() - " + evt.getActionCommand() +
    " clicked");
    
    // Create and configure the ViewEvent
    int eventType = 0;
    String actionCommand = evt.getActionCommand();
    
    if (actionCommand.equals(EXIT)) {
        eventType = ViewEvent.EXIT;
        
    } else if (actionCommand.equals(SHOW_GAME_RESULTS)) { 
        eventType = ViewEvent.SHOW_RESULTS;
        
    } else if (actionCommand.equals(START_NEW_GAME)) { 
        eventType = ViewEvent.START_NEW_GAME;
        
    } else {
        eventType = ViewEvent.DOOR_SELECTED;
    }
    ViewEvent event = new ViewEvent(eventType);
    event.setID(id);
    
    // Get door number clicked
    String stringNumber = evt.getActionCommand(); // 1 based
    int intNumber = 0;
    try {
        intNumber = Integer.parseInt(stringNumber);
    } catch(Exception ex) {
        print(".actionPerformed() - Door number is not int, it's " + stringNumber);
    }
    event.setSelectedDoor(intNumber);
    
    // Send event to all ViewListeners
    Vector list = (Vector)listeners.clone();
    for (int i = 0; i < list.size(); i++) {
        ViewListener listener = (ViewListener)list.elementAt(i);
        listener.processViewEvent(event);
    }
}
//---------- Properties ------------------------------------------
public void setID(int id) {
    this.id = id;
}
public int getID() {
    return id;
}
public void setVisible(boolean isVisible) {
    window.setVisible(isVisible);
}
//---------- Events ----------------------------------------------
public void addViewListener(ViewListener listener) {
    print(".addViewListener() - Listener added");
    listeners.addElement(listener);
}
public void removeViewListener(ViewListener listener) {
    listeners.removeElement(listener);
}
//---------- Protected Methods -----------------------------------
// Note the doorIndex is zero based
protected Panel addDoorPanel(int doorIndex) {
    Panel panel = new Panel();
    panel.setLayout(new BorderLayout());
    
    // Init arrays
    selectedLabels[doorIndex] = new Label();
    doorLabels[doorIndex]     = new Label("?");
    
    // Create and config button    
    Button button = createButton("Door " + (doorIndex + 1), 
        "" + (doorIndex + 1));
    
    // Add 3 widgets to panel
    panel.add(selectedLabels[doorIndex], "North");
    panel.add(doorLabels[doorIndex], "Center");
    panel.add(button, "South");
    
    return panel;
}
protected Button createButton(String text, String command) {
    Button button = new Button(text);
    button.setActionCommand(command);
    button.addActionListener(this);
    return button;
}
//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("View" + text);
}

} // End class