package org.jsl.threedoor;

/**
* This class is a pure data structure, representing a single
* event fired by the Model. All indexed collections are zero based.
*
* @author Tim McCauley
*/
public class ModelEvent {

//---------- Public Fields ---------------------------------------
public static final int NUMBER_DOORS = 3;

//---------- Internal Fields -------------------------------------
protected int id;
protected int runningScore;
protected int carDoor;
protected int selectedDoor;
protected boolean[] openedDoors = new boolean[NUMBER_DOORS];

//---------- Superclass Override ---------------------------------
public String toString() {
    String text = "[id=" + id + ", runningScore=" + runningScore +
        ", carDoor=" + carDoor + ", selectedDoor=" + selectedDoor +
        ", openedDoors=";
    for (int i = 0; i < openedDoors.length; i++) {
        text += openedDoors[i];
        if (i < openedDoors.length - 1) text += ", ";
    }
    return text + "]";
}
//---------- Properties ------------------------------------------
//----- id
public void setID(int id) {
    this.id = id;
}
public int getID() {
    return id;
}
//----- running score
public void setRunningScore(int runningScore) {
    this.runningScore = runningScore;
}
public int getRunningScore() {
    return runningScore;
}
//----- carDoor
public void setCarDoor(int carDoor) {
    this.carDoor = carDoor;
}
public int getCarDoor() {
    return carDoor;
}
//----- selectedDoor
public void setSelectedDoor(int selectedDoor) {
    this.selectedDoor = selectedDoor;
}
/**
* Returns the selected door index or zero if none.
*/
public int getSelectedDoor() {
    return selectedDoor;
}
//---------- Public Methods --------------------------------------
public void setOpenedDoor(int door, boolean isOpen) {
    openedDoors[door] = isOpen;
} 
public boolean isDoorOpen(int door) {
    return openedDoors[door];
} 
//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("ModelEvent" + text);
}

} // End class
  