package org.jsl.threedoor;

import java.util.Vector;

/**
* This class is the model in the MVC pattern. It emits ModelEvents
* which are sent to ModelListeners. It keeps all state for one
* game series.
*
* @author Jack Harich
*/
public class Model {

//---------- Internal Fields -------------------------------------
protected Vector    listeners = new Vector(); // ModelListeners
protected int       id;             // Matches the view with that model
protected int       runningScore;
protected int       carDoor;        // 1, 2, or 3
protected int       selectedDoor;   // 0 for none, 1, 2, or 3
protected boolean   isDone;         // true when Show Game Results clicked
protected boolean[] openedDoors = new boolean[ModelEvent.NUMBER_DOORS];

//---------- Properties ------------------------------------------
//----- id
public void setID(int id) {
    this.id = id;
}
public int getID() {
    return id;
}
//----- selectedDoor
public int getSelectedDoor() {
    return selectedDoor;
}
public void selectOneDoor(int selectedDoor) {
    this.selectedDoor = selectedDoor;
    fireModelEvent();
}
//----- Other
public int getCarDoor() {
    return carDoor;
}
//---------- Events ----------------------------------------------
public void addModelListener(ModelListener listener) {
    listeners.addElement(listener);
}
public void removeModelListener(ModelListener listener) {
    listeners.removeElement(listener);
}
//---------- Public Methods --------------------------------------
public void startNewGame() {

    //----- Reinitialize all game state
    selectedDoor = 0;
    isDone       = false;
    carDoor      = GeneralLibrary.getRandomInt(1, ModelEvent.NUMBER_DOORS);
    
    // Close all doors
    for (int i = 0; i < ModelEvent.NUMBER_DOORS; i++) {
        openedDoors[i] = false;
    }
    
    //----- Fire event
    fireModelEvent();
}
public void openDoor(int door) {
    openedDoors[door] = true;
    fireModelEvent();
}
public void incrementScore(int points) {
    runningScore += points;
    fireModelEvent();
}
//---------- Protected Methods -----------------------------------
protected void fireModelEvent() {

    // Configure the event
    ModelEvent event = new ModelEvent();
    event.setID(id);
    event.setSelectedDoor(selectedDoor);
    event.setCarDoor(carDoor);
    
    for (int i = 0; i < ModelEvent.NUMBER_DOORS; i++) {
        event.setOpenedDoor(i, openedDoors[i]);
    }
    // Send to listeners
    Vector list = (Vector)listeners.clone();
    // slower for (int i = 0; i < list.size(); i++) {
    for (int i = list.size() - 1; i >= 0; i--) {
        ModelListener listener = (ModelListener)list.elementAt(i);
        listener.processModelEvent(event);
    }
    print("ModelEvent fired to all listeners " + event);
}
//---------- Standard --------------------------------------------
private void print(String text) {
    System.out.println("Model " + id + " - " + text);
}

} // End class