package org.jsl.threedoor;

/**
* This class has the responsibilities of an "initializaer mediator".
* It creates the main objects, establishes their relationships, and
* lastly "starts" key objects. After that this class does nothing.
*
* @author Jack Harich
*/
public class Mediator {

//---------- Internal Fields -------------------------------------
protected static final int NUMBER_GAMES = 2;

//---------- Initialization --------------------------------------
public static void main(String[] args) {
    new Mediator().start();
}
//---------- Public Methods --------------------------------------
/**
* This starts the entire Three Door Game.
*/
public void start() {
    // Create main objects
    Controller controller = new Controller();
    
    for (int i = 1; i <= NUMBER_GAMES; i++) {
        // View
        View view = new View();
        view.setID(i);
        view.addViewListener(controller);
        view.setVisible(true);
        
        // Model
        Model model = new Model();
        model.setID(i);
        model.addModelListener(view);
        
        controller.addModel(model);
    }
    // Start the first game
    controller.startNewGame();
    
    print(".start() - started");
}
//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("Mediator" + text);
}

} // End class