package org.jsl.threedoor;

import java.util.Random;

/**
* These are static methods for general use.
* The main() is the unit test.
*
* @Author: Tim McCauley
*/
public final class GeneralLibrary {

//---------- Public Methods --------------------------------------
public static int getRandomInt(int lower, int upper) {
    Random random = new Random();

    int modValue = 0;
    int mod = 0;

    // if the same just return one of them
    if(lower == upper) return upper;

    // calculate the value for the modulus divisor
    // handle range like 0 to 3 and 2 to 5
    if((lower >= 0) && (upper > 0)) {
        mod = (upper - lower) + 1;
    } else if((lower < 0) && (upper >= 0)) {
        // handle range like -9 to 0 and -9 to 6
        mod = (Math.abs(lower) + upper) + 1;
    } else if((lower < 0) && (upper < 0)) {
        // handle range like -9 to -3
        mod = (Math.abs(lower) - Math.abs(upper)) + 1;
    }

    do {
        // +/- mod-1
        modValue = random.nextInt() % mod;
    } while( modValue < 0);

    return modValue + lower;
}
public static void main(String[] args) {
    int temp;
    int[] temparray = new int[7];
    for(int i=0; i<100000; i++) {
      temp = getRandomInt(3, 9);
      temparray[temp-3]++;
    }
    for(int i=0; i<temparray.length; i++) {
      System.out.println("value at " + (i+3) + " = " + temparray[i]);
    }
    for(int i=0; i<100000; i++) {
      temp = getRandomInt(0, 6);
      temparray[temp]++;
    }
    for(int i=0; i<temparray.length; i++) {
      System.out.println("value at " + i + " = " + temparray[i]);
    }
    for(int i=0; i<100000; i++) {
      temp = getRandomInt(-3, 3);
      temparray[temp+3]++;
    }    
    for(int i=0; i<temparray.length; i++) {
      System.out.println("value at " + (i-3) + " = " + temparray[i]);
    }
    for(int i=0; i<100000; i++) {
      temp = getRandomInt(-9, -3);
      temparray[temp+9]++;
    }
    for(int i=0; i<temparray.length; i++) {
      System.out.println("value at " + (i-9) + " = " + temparray[i]);
    }
    for(int i=0; i<100000; i++) {
      temp = getRandomInt(-6, 0);
      temparray[temp+6]++;
    }
    for(int i=0; i<temparray.length; i++) {
      System.out.println("value at " + (i-6) + " = " + temparray[i]);
    }
}
  
} // End class
    
    