package org.jsl.threedoor;

import java.util.Vector;

/**
* This class is the controller for the MVC Pattern.
*
* @author Jack Harich
*/
public class Controller implements ViewListener {

//---------- Internal Fields -------------------------------------
protected Vector models = new Vector();

//---------- ViewListener Implementation -------------------------
public void processViewEvent(ViewEvent evt) {
    print(".processViewEvent() - " + evt);
    
    // Given eventType, take appropriate action
    
    if (evt.getEventType() == ViewEvent.DOOR_SELECTED) {
        // NOTE - This could now be improved with getModeForID()
        for (int i = 0; i < models.size(); i++) {
            Model model = (Model)models.elementAt(i);
            if (evt.getID() == model.getID() ) {
                model.selectOneDoor(evt.getSelectedDoor());
                break; // Found correct model, why continue? :-)
            }    
        }
    } else if (evt.getEventType() == ViewEvent.SHOW_RESULTS) {
        
        // Determine win or loss
        boolean isWin = false;
        Model model = getModelForID(evt.getID());
        if (model.getSelectedDoor() == model.getCarDoor()) {
            isWin = true;
        }
        // Increment running score
        if (isWin) model.incrementScore(1);
        // Open all doors
        for (int i = 1; i <= View.NUMBER_DOORS; i++) {
            model.openDoor(i);
        }
    
    } else if (evt.getEventType() == ViewEvent.START_NEW_GAME) {
        // All this business logic is in the Model for now
        getModelForID(evt.getID()).startNewGame();
    
    } else if (evt.getEventType() == ViewEvent.EXIT) {
        System.exit(0);
    
    } else {
        print(".processViewEvent() - eventType = "
            + evt.getEventType() + " - Unknown event type!!!");
    }
}
//---------- Public Methods --------------------------------------
public void addModel(Model model) {
    models.addElement(model);
}
public void startNewGame() {
    for (int i = 0; i < models.size(); i++) {
        Model model = (Model)models.elementAt(i);
        model.startNewGame();
    }
}
//---------- Private Methods -------------------------------------
private Model getModelForID(int id) {
    for (int i = 0; i < models.size(); i++) {
        Model model = (Model)models.elementAt(i);
        if (model.getID() == id) return model;
    }
    return null; // Should never happen
}
//---------- Standard --------------------------------------------
private static void print(String text) {
    System.out.println("Controller" + text);
}

} // End class


    