package org.jcon.core.proto.c2.std;

import org.jcon.core.proto.c2.Cell;
import org.jcon.core.proto.c2.Node;
import org.jcon.core.proto.c2.PartReader;
import java.util.Enumeration;
import java.util.Vector;

/**
* This class is the standard PartReader. See interface for doc.
*
* @author Jack Harich
*/
public class PartReaderStd implements PartReader {

//---------- Protected Fields ----------------------------
protected Cell myCell;

//---------- PartReader Implementation -------------------
public Object findPart(String partName) {
    return myCell.findPart(partName);
}
public Enumeration getParts() {
    // Well, this may not be the best way, but...
    Vector parts = new Vector();
    Enumeration nodes = myCell.getNodes();
    while (nodes.hasMoreElements()) {
        Node node = (Node)nodes.nextElement();
        parts.addElement(node.getPart()); 
    }
    return parts.elements();
}
public int getPartCount() {
    return myCell.getNodeCount();
}
public Object getPartAt(int index) {
    return myCell.getNodeAt(index).getPart();
}
public String listTree(boolean startAtRoot) {
    Cell startingCell = myCell;
    
    if (startAtRoot) {
        startingCell = (Cell)myCell.getCellNode().getRootNode().getPart();
    }
    String text = startingCell.getCellNode().getName();
    return text + "\n" + listCell(startingCell, 1);    
}
//----- PartUser Implementation 
public String[] getPartNeeds() {
    return new String[] {"MyCell"};
}
public void setPart(String name, Object part) {
    if (name.equals("MyCell")) myCell = (Cell)part;
}
//------ Replicable Implementation 
public Object replicate() {
    // No DK so this is easy
    return new PartReaderStd();
}
//---------- Protected Methods ---------------------------
// RECURSIVE
protected String listCell(Cell cell, int level) {

    String text = ""; 
    Enumeration nodes = cell.getNodes();
    while (nodes.hasMoreElements()) {
        Node node = (Node)nodes.nextElement();
        // Build prefix of spaces, which is level * indent
        // Why doesn't Java have an easy way to do this?
        int indent = 4;
        int spaces = level * indent;
        String prefix = "";
        for (int j = 1; j <= spaces; j++) {
            prefix += " ";
        }
        // Build line
        text += prefix + node.getName() + "\n";
        
        // RECURSE if container
        if (node.isContainer()) {
            text += listCell((Cell)node.getPart(), level + 1);            
        }
    }
    return text;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("PartReaderStd" + text);
}


} // End class