package org.jcon.core.proto.c2.std;

import org.jcon.core.proto.c2.Cell;
import org.jcon.core.proto.c2.Node;
import org.jcon.core.proto.c2.RootNodeCreator;

/**
* This class creates root nodes for "Minimal Core" systems.
*
* @author Jack Harich
*/

public class MinimalCore implements RootNodeCreator {

//---------- RootNodeCreator Implementation --------------
public Node createRootNode() {
    
    //----- Create root node
    Node rootNode = new NodeStd();
    rootNode.setName("Root");
    rootNode.setCore(true);
    rootNode.setVirtual(true);
    rootNode.setContainer(true);
    
    // Create root cell, put in root node
    Cell cell = new CellStd();
    rootNode.setPart(cell);
    
    //----- Populate root cell with other core parts 
    Node node;
    
    // RootNodeCreator - This very object, inherited
    node = createCoreNode("RootNodeCreator", rootNode);
    node.setPart(this);
    node.setInheritable(true);
    cell.appendNode(node);
    
    // PartReader, not inheritable
    node = createCoreNode("PartReader", rootNode);
    node.setPart(new PartReaderStd());
    cell.appendNode(node);
        
    // CellNodeReplicator, inherited
    node = createCoreNode("CellNodeReplicator", rootNode);
    node.setPart(new CellNodeReplicatorStd());
    node.setInheritable(true);
    cell.appendNode(node);
           
    //----- Done
    return rootNode;
}
//---------- Protected Methods ---------------------------
protected Node createCoreNode(String name, Node parentNode) {
    Node node = new NodeStd();
    node.setName(name);
    node.setParentNode(parentNode);
    node.setCore(true);
    node.setVirtual(true);
    node.setHidden(true);
    return node;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("MinimalCore" + text);
}


} // End interface