package org.jcon.core.proto.c2.std;

import org.jcon.core.proto.c2.Cell;
import org.jcon.core.proto.c2.CellNodeReplicator;
import org.jcon.core.proto.c2.Node;
import org.jcon.core.proto.c2.PartReader;
import org.jcon.core.proto.c2.PartUser;
import org.jcon.core.proto.c2.Replicable;
import java.util.Enumeration;

/**
* This class is the standard Cell. See interface for doc.
* <p>
* TODO - Consider CorePart interface for node properties.
*
* @author Jack Harich
*/

public class CellNodeReplicatorStd 
                        implements CellNodeReplicator {

//---------- CellNodeReplicator Implementation -----------
public Node createCellNode(Node fromNode) {

    if (fromNode == null) throw new IllegalArgumentException(
        "The fromNode is null. Cannot proceed since fromNode is required.");
        
    Cell fromCell = (Cell)fromNode.getPart();
    Cell newCell  = (Cell)fromCell.replicate();
    
    // Populate newCell with core, non-container, 
    //   non-inheritable parts in fromCell
    Enumeration nodes = fromCell.getNodes();
    while (nodes.hasMoreElements()) {
        Node node = (Node)nodes.nextElement();
        if (node.isCore() && ! node.isContainer()
                && ! node.isInheritable()) {
            // These MUST all be Replicable
            Replicable oldPart = (Replicable)node.getPart();
            Object newPart = oldPart.replicate();
            
            Node newNode = new NodeStd();
            newNode.setName(node.getName());
            newNode.setParentNode(fromNode);
            newNode.setPart(newPart);
            newNode.setCore(true);
            newNode.setVirtual(true);
            newNode.setHidden(true);
            
            newCell.appendNode(newNode);
        }
    }
    // Put newCell in its own node
    // Note we do not set the name
    Node newNode = new NodeStd();
    newNode.setParentNode(fromNode);
    newNode.setPart(newCell);
    newNode.setCore(true);
    newNode.setVirtual(true);
    newNode.setContainer(true);
    
    // Done
    return newNode;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("CellNodeReplicatorStd" + text);
}

                        
} // End class                        