package org.jcon.core.proto.c2;

import java.util.Enumeration;

/**
* This interface allows reading parts from a cell. It acts
* as a cell Fascade. (More methods will be added)
* <p>
* The PartUser implementation should get the "Cell" for
* use in getting parts.
*
* @author Jack Harich
*/
public interface PartReader extends PartUser, Replicable {

/**
* Returns the named part or throws an IllegalStateException
* if not found. Can find "local" or "inherited" parts. If
* the part is not found in the cell, an upward
* search is made until the root cell is encountered.
* These are the cases: 
* <p> <p>
* 1. The part is found in the cell and returned. 
* Note it may be a local or inheritable part.
* <p> <p>
* 2. The part is never found, so the exception is thrown.
* <p> <p>
* 3. The part is found upwardly, is an inheritable part and
* is returned.
* <p> <p>
* 4. The part is found upwardly but is not an inheritable
* part, and so the exception is thrown.
* <p>
* A special case is when the cell is needed. Since this 
* usually has a custom name, the reserved partName "MyCell"
* can be used to get the cell the PartReader is in.
* <p>
* A possible feature is if the partName contains slashes, 
* we look downward for it in a standard file path manner.
* We frown on this, because in creates large dependencies.
*/
public Object findPart(String partName);

/**
* Returns an Enumeration of the parts in the cell. 
*/
public Enumeration getParts();

/**
* Returns the number of parts in the cell.
*/
public int getPartCount();

/**
* Returns the part at the index or throws an 
* IllegalStateException if none.
*/
public Object getPartAt(int index);

/**
* Returns a String representing the System Tree, starting
* at the root or at the cell this PartReader is in.
* Format is one line per part ith indentation. This is for 
* simple developement use.
*/
public String listTree(boolean startAtRoot);


} // End interface