package org.jcon.core.proto.c2;

/**
* This interface is responsible for replicating cell nodes
* given an existing parent cell node to replicate from.
* <p>
* Look closely. When creating new cells, this interface
* adds various core parts using replication. In 
* effect this allows pre-existing life to reproduce and
* create a new life form. This is cellular reproduction.
* <p>
* Note that not all core parts are added, because some are
* inheritable parts. These are available to any cell without
* being in the cell. This greatly reduces cell bloat.
*
* @author Jack Harich
*/

public interface CellNodeReplicator {

/**
* Creates a new node with a new cell. The cell contains
* the parts necessary for core work. Note the new node
* does not yet have a name.
*/
public Node createCellNode(Node fromNode);


} // End interface