package org.jcon.core.proto.c1.test;

import org.jcon.core.proto.c1.Cell;
import org.jcon.core.proto.c1.CellCreator;
import org.jcon.core.proto.c1.CellServices;
import org.jcon.core.proto.c1.CellTree;
import org.jcon.core.proto.c1.Part;
import org.jcon.core.proto.c1.WorkerWrapper;
import org.jcon.core.proto.c1.std.WorkerWrapperStd;
import org.jcon.core.proto.c1.std.CellCreatorStd;

/**
* This class tests the concept of core parts replacing a
* kernel via a self referential style. This is a prototype.
*
* @author Jack Harich
*/ // java -nojit org.jcon.core.proto.c1.test.CorePrototype1
public class CorePrototype1 {

//---------- Initialization ------------------------------
public static void main(String args[]) {
    CorePrototype1 test = new CorePrototype1();
    String results = test.runTest();
    print(" ----> " + results);
}
//---------- Public Methods ------------------------------
/**
* Runs the test and returns a summary of the results.
*/
public String runTest() {
    CellCreator creator = new CellCreatorStd();
    
    // Create root cell. Later setMarker(), setParamStore()
    Cell rootCell = creator.createPrimordialCell();
    rootCell.setName("Root");
    
    // Create, add and start Instigator
    Instigator1 instigator = new Instigator1();
    WorkerWrapper wrapper = new WorkerWrapperStd();
    wrapper.setWorker(instigator);
    wrapper.setName("DomainPart1");
    
    rootCell.addPart(wrapper);
    instigator.startPart();
    
    // Various checks    
    CellTree tree = (CellTree)rootCell.findWorker("CellTree");
    print(" - We have created a system tree with this " +
        "structure: \n" + tree.listTree(rootCell));
    
    return "Test Complete, looks like a breakthrough to me!!! :-)";
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("CorePrototype1" + text);
}

} // End class