package org.jcon.core.proto.c1.std;

import org.jcon.core.proto.c1.Cell;
import org.jcon.core.proto.c1.Part;

/**
* This class is the standard Part. For complete
* documentation see Part for now. 
*
* @author Jack Harich
*/
public class PartStd implements Part {

//---------- Protected Fields ----------------------------
protected String    name;
protected Cell      parent;
protected boolean   isCore;
protected boolean   isContainer;
protected boolean   isCompanion;
protected boolean   isService;
protected boolean   isVirtual;
protected boolean   isHidden;

//---------- Part Implementation -------------------------

public void setName(String name) {
    // TODO Assertions later
    this.name = name;
}
/*
* Returns the part name.
*/
public String getName() {
    return name;
}
//---------- paremt --------------------------------------
/*
* Sets the part's parent cell. This is required for 
* all parts in a tree except the root, which is null.
*/
public void setParent(Cell parent) {
    this.parent = parent;
}
/*
* Returns the part's parent cell or null if this is
* the root.
*/
public Cell getParent() {
    return parent;
}
//---------- isCore --------------------------------------
/**
* Sets whether this is a core part or not. The default is
* false.
*/
public void setCore(boolean isCore) {
    this.isCore = isCore;
}
/**
* Returns true if this is a core part or false if not.
*/
public boolean isCore() {
    return isCore;
}
//---------- isContainer ---------------------------------
/**
* Sets whether this is a container part or not. The default
* is false.

*/
public void setContainer(boolean isContainer) {
    this.isContainer = isContainer;
}
/**
* Returns true if this is a container part or false if not.
*/
public boolean isContainer() {
    return isContainer;
}
//---------- isCompanion ---------------------------------
/**
* Sets whether this is a companion part or not. The default
* is false.

*/
public void setCompanion(boolean isCompanion) {
    this.isCompanion = isCompanion;
}
/**
* Returns true if this is a companion part or false if not.
*/
public boolean isCompanion() {
    return isCompanion;
}
//---------- isService -----------------------------------
/**
* Sets whether this is a service part or not. The default is
* false.
*/
public void setService(boolean isService) {
    this.isService = isService;
}
/**
* Returns true if this is a service part or false if not.
*/
public boolean isService() {
    return isService;
}
//---------- isVirtual -----------------------------------
/**
* Sets whether this is a virtual part or not. The default is
* false.
*/
public void setVirtual(boolean isVirtual) {
    this.isVirtual = isVirtual;
}
/**
* Returns true if this is a virtual part or false if not.
*/
public boolean isVirtual() {
    return isVirtual;
}
//---------- isHidden -----------------------------------
/**
* Sets whether this is a hidden part or not. The default is
* false.
*/
public void setHidden(boolean isHidden) {
    this.isHidden = isHidden;
}
/**
* Returns true if this is a hidden part or false if not.
*/
public boolean isHidden() {
    return isHidden;
}
//----- Other
public Object clone() throws CloneNotSupportedException {
    return super.clone();
}    
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("PartStd" + text);
}

} // End class