package org.jcon.core.proto.c1;

/**
* A worker may optionally implement this interface to 
* indicate it needs to use the Cell it's in. If so, then
* during initialization setCell(Cell) will be called.
* <p>
* This should not be used by too many parts, or system
* will be hard to understand and be full of bugs. In
* general it's for core parts and those few parts
* engaging in dynamic system behavior, such as adding
* parts at runtime.
*
* @author Jack Harich
*/
public interface CellUser {

/**
* Sets the Cell that can be used by the worker.
*/
public void setCell(Cell cell);

/**
* The implementor should release its reference to the Cell
* by setting it to null. This is useful when a part is 
* removed from one cell, and perhaps moved to another.
*/
public void releaseCell();


} // End interface

/**

import org.jcon.core.Cell;
import org.jcon.core.CellUser;

//----------- CellUser Implementation --------------------
public void setCell(Cell cell) {
    this.cell = cell;
}
public void releaseCell() {
    cell = null;
}

*/