package org.jcon.core.proto.c1;

/**
* A worker may optionally implement this interface to 
* indicate it needs to use CellServices. If so, then
* during initialization setCellServices(CellServices)
* will be called.
* <p>
* A common sceanario is to use CellServices to get a
* reference to another worker, cast it, and then use it
* directly. While this increases coupling, it increases
* speed, decreases code size, and allows the designer a
* great deal of flexibility.
* <p>
* This interface only allows non-mutator calls to the cell.
* More domain parts need this than need cell mutator abilities.
* <p>
* The design philosophy behind this interface is parts
* may need a more direct means to interact with other
* domain parts, or even core parts, than the indirect
* mechanism of Messages. This is particularly true for
* Visual Tools, systems not using Messages, and high
* performance areas of systems. There is a tradeoff
* between the loose coupling of Messages and the high
* coupling of direct calls, which can be reduced somewhat
* with interfaces. In general we anticipate core parts
* using direct calls more, and domain parts using
* Messages more.
*
* @author Jack Harich
*/
public interface CellServicesUser {

/**
* Sets the CellServices that can be used by the worker.
*/
public void setCellServices(CellServices cellServices);

/**
* The implementor should release its reference to the CellServices
* by setting it to null. This is useful when a part is 
* removed from one cell, and perhaps moved to another.
*/
public void releaseCellServices();


} // End interface

/**

import org.jcon.core.CellServices;
import org.jcon.core.CellServicesUser;

//----------- CellServicesUser Implementation ------------
public void setCellServices(CellServices cellServices) {
    this.cellServices = cellServices;
}
public void releaseCellServices() {
    cellServices = null;
}

*/