package org.jcon.core.proto.c1;

import java.util.Vector;

/**
* This interface is responsible for replicating cells
* given an existing parent cell to replicate from.
* <p>
* Look closely. When creating new cells, this interface
* adds various core parts using replication. In 
* effect this allows pre-existing life to reproduce and
* create a new life form. This is cellular reproduction.
* <p>
* Note that not all core parts are added, because some are
* service parts. These are available to any cell without
* being in the cell. This greatly reduces cell bloat.
*
* @author Jack Harich
*/
public interface CellReplicator {

/**
* Sets the core part names the replicator needs to work.
* This could be done by searches, but is simpler and more
* efficient if provided. However this is a less dynamic
* technique, and we may change it in the future.
*/
public void setCorePartNames(Vector names);

/**
* Creates and returns a ready-to-use new cell that has 
* the fromCell as its parent. The new cell has the necessary
* non-service core parts, but no domain parts. Its state is
* uninitialized. 
* <p>
* The client is responsibile for setting the part name of
* the newly created cell.
*
* @param fromCell  the cell to get core workers from. If 
* insufficient data an IllegalStateException is thrown.
* This can be caused by replication difficulties. If
* fromCell is null an IllegalArgumentException is thrown.
*
* @return  a cell based on the fromCell, with the fromCell
*          as its parent.
*/
public Cell replicateCell(Cell fromCell);

} // End interface