package gov.cdc.atsdr.server;

// import org.jcon.util.GenLib;
import org.jcon.df.EntityEvent;
import org.jcon.df.EntityEventReply;
import org.jcon.df.EntityListener;
import org.jcon.df.work.Row;

/**
 * This class validates entity mutations. It handles
 * multiple entities.
 *
 * @author Jack Harich
 */
public class EntityValidator implements java.io.Serializable,
    EntityListener {

//---------- EntityListener Implementation ---------------
public EntityEventReply processEntityEvent(EntityEvent evt) {
    String entityName = evt.getEntityName().intern();
    
    if (entityName == "UserSys") {
        return validateUserSys(evt);
    } 
    return null; // Okay
}    
//---------- Private Methods -----------------------------
private EntityEventReply validateUserSys(EntityEvent evt) {
    // Validate only add or update
    if (evt.getEventType() != EntityEvent.VALIDATE_ADD &&
        evt.getEventType() != EntityEvent.VALIDATE_UPDATE) {
            return null;
    }
    String TABLE = "UserSys.";
    Row row = evt.getRow();
    boolean isAdmin = row.isTrue(TABLE + "IsAdmin");
    
    print(".validateUserSys() - Before get UserProfileMID");
    String userProfileMID = null;
    try {
        userProfileMID = row.getString(TABLE + "UserProfileMID");
    } catch(Exception ex) {
        // Do nothing   
    }
    print(".validateUserSys() - isAdmin = " + isAdmin + ", userProfileMID = '" + userProfileMID + "'");
    
    if (! isAdmin && userProfileMID == null) {
        EntityEventReply reply = new EntityEventReply();
        reply.setInvalidColumnName("UserProfileMID");
        reply.setInvalidMessage("If not an Admin then must have a User Profile.");
        return reply;
    }
    return null; // Okay
}    

//--- Std
private static void print(String text) {
    System.out.println("EntityValidator" + text);
}

} // End class