package gov.cdc.atsdr.client.user;

import org.jcon.df.edit.DataEditorTask;
import org.jcon.df.edit.DataView;
import org.jcon.df.edit.control.*;
import org.jcon.df.edit.module.*;
import org.jcon.df.request.DataRequestDef;
import org.jcon.df.work.DataSource;
import org.jcon.ui.OutputConsole;
import org.jcon.util.GenLib;
import org.jcon.ui.easylayout.EasyLayout;
import org.jcon.ui.VisualLib;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * The edit users task. Replaces parex approach for speed.
 * THIS IS NOT USED, and was an experiment.
 * Save for possible future use.
 *
 * Test: java gov.cdc.atsdr.client.user.EditUserSys
 *
 * @author Jack Harich
 */
public class EditUserSys implements DataEditorTask {

//---------- Private Fields ------------------------------

// Key = viewName, Object = DataView
private Hashtable views = new Hashtable();

// Key = DataSourceID, Object = DataSource
private Hashtable sources = new Hashtable();

//---------- Initialization ------------------------------
public static void main(String args[]) {
    new EditUserSys().runUnitTest();
}
//---------- DataEditorTask Implementation ---------------
// To allow delayed instantiation work
public void init() {
    // later createBrowseView();
    createFieldView();
    createSource();
}
public Hashtable getDataViews() {
    return views;
}
public Hashtable getDataSources() {
    return sources;
}
//---------- Private Methods -----------------------------
//---------- FieldView view
private void createFieldView() {
    //----- Create FieldView
    DataView view = new DataView();
    views.put("FieldView", view);

    // Properties
    view.setTitle("Edit UserSys Table");
    view.setPrimeView(true);
    // Some - view.setWindowPosition("XXX");
    // Some - view.setWindowSize(123, 123);

    // Add modules
    EasyLayout layout = view.getEasyLayout();
    addRowFieldPanel(view, layout);
    addMoveButtonBar(view, layout);
    addEditButtonBar(view, layout);

    // Done
    view.init();
}
private void addRowFieldPanel(DataView view, EasyLayout layout) {
    RowFieldPanel module = new RowFieldPanel();
    view.addModule(module);
    module.setEditListener(view);
    layout.add(module.getComponent(), "Default", "EndRow");
    layout.beginNestedContainer();

    // UserID - first component
    createLabel("User ID", "FieldRight", layout);

    TextFieldControl userIDControl = new TextFieldControl(10);
    userIDControl.setController(view);
    userIDControl.setFirstComponent(true);
    userIDControl.setColumnID("UserSys.UserID");
    layout.add(userIDControl.getComponent(), "FieldLeft", "EndRow");

    // Password
    createLabel("Password", "FieldRight", layout);
    createTextField("UserSys.Password", 10,
        "FieldLeft", "EndRow", layout, view);

    // AdminCode
    createLabel("Admin Code", "FieldRight", layout);
    createTextField("UserSys.AdminCode", 7,
        "FieldLeft", "EndRow", layout, view);

    // IsAdmin
    createLabel("Is Admin", "FieldRight", layout);

    BooleanControl isAdminControl = new BooleanControl();
    isAdminControl.setController(view);
    isAdminControl.setColumnID("UserSys.UserID");
    layout.add(isAdminControl.getComponent(), "FieldLeft", "EndRow");

    // SSN
    createLabel("SSN", "FieldRight", layout);
    createTextField("UserSys.SSN", 11,
        "FieldLeft", "EndRow", layout, view);

    // FirstName
    createLabel("First Name", "FieldRight", layout);
    createTextField("UserSys.FirstName", 20,
        "FieldLeft", "EndRow", layout, view);

    // MiddleInitial
    createLabel("Initial", "FieldRight", layout);
    createTextField("UserSys.MiddleInitial", 1,
        "FieldLeft", "EndRow", layout, view);

    // LastName
    createLabel("Last Name", "FieldRight", layout);
    createTextField("UserSys.LastName", 20,
        "FieldLeft", "EndRow", layout, view);

    // LastLogon
    createLabel("Last Logon Date", "FieldRight", layout);
    createTextField("UserSys.LastLogon", 10,
        "FieldLeft", "EndRow", layout, view);

    layout.endNestedContainer();
}
private void createLabel(String text, String style, EasyLayout layout) {
    layout.add(new LabelControl(text).getComponent(), style);
}
private void createTextField(String columnID, int columns,
        String style, String addType,
        EasyLayout layout, DataView view) {

    TextFieldControl control = new TextFieldControl(columns);
    control.setController(view);
    layout.add(control.getComponent(), style, addType);

}
private void addMoveButtonBar(DataView view, EasyLayout layout) {
    MoveButtonBar module = new MoveButtonBar();
    view.addModule(module);
    module.setEditListener(view);
    module.setDataSourceID("UserSysSource");

    layout.add(module.getComponent(), "GapTopBottomLeft", null);
}
private void addEditButtonBar(DataView view, EasyLayout layout) {
    EditButtonBar module = new EditButtonBar();
    view.addModule(module);
    module.setEditListener(view);
    module.setDataSourceID("UserSysSource");

    layout.add(module.getComponent(), "GapTopBottomRight", null);
}
//---------- UserSys source
/**   --- Simulate Param ---
    Entity is: UserSys
    DataRequest has:
        Database is: atsdr
        ColumnIDs hasLines:
            UserSys.*
            End: ColumnIDs
        Entities is: UserSys
        SortBy is: LastName, FirstName
        End: DataRequest */
private void createSource() {
    //----- Create UserSysSource
    DataSource source = new DataSource();
    sources.put("UserSysSource", source);

    // Do this later in DataEditor ***
    //Database database = services.createDatabase("atsdr");
    //source.setDatabase(database);
    //source.setEntity(database.getSchema().getEntity("UserSys"));

    DataRequestDef request = new DataRequestDef();
    // Later support addAllColumnIDs("UserSys.*");
    // ***request.addAllColumnIDs("UserSys.*", database.getSchema());
    // Some - request.addColumnID("XXX.XX");
    request.addEntity("UserSys");
    request.setSortBy("LastName, FirstName");
    // Some - addJoin("XXX");
    // Some - setFilterLine("XXX");
}
//---------- Other
// Standardized. Show all views. Sources not tested.
private void runUnitTest() {
    //print(".runUnitTest() - Entered " + GenLib.startTimePoint());
    //new OutputConsole().setVisible(true);

    //print(".runUnitTest() - Starting test " + GenLib.startTimePoint());
    VisualLib.installLookAndFeel();
    init();

    Enumeration enum = views.elements();
    while (enum.hasMoreElements()) {
        DataView view = (DataView)enum.nextElement();
        view.setVisible(true);
    }
    //print(".runUnitTest() - Test complete " + GenLib.getTimePoint());
}
//--- Std
private static void print(String text) {
    System.out.println("EditUserSys" + text);
}

} // End class