package gov.cdc.atsdr.client;

import org.jcon.ba.system.*;
import org.jcon.ui.InfoBar;
import org.jcon.ui.menu.MenuFramePD;
import org.jcon.ui.MessageBox;
import org.jcon.ui.WindowMgr;
import org.jcon.util.GenLib;
import org.jcon.util.Hub;
import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageDef;
import org.jcon.util.msg.MessageListener;
import org.jcon.util.msg.MessageSourceStd;
import java.util.Vector;

/**
 * The mediator for the DataClient system.
 *
 * @author Jack Harich
 */
public class Mediator extends MessageSourceStd
    implements MessageListener, BeanPriv, BeanActionStart {

//---------- Private Fields ------------------------------
private BasketServices basketServices;
private MenuFramePD    systemMenu;
// ***private User           user; // Current user, null if none
private InfoBar        infoBar;
private boolean        isSystemStarted;

//---------- MessageSourceStd Abstractions ---------------
public Vector getMessageDefs() {
    Vector defs = new Vector();
    MessageDef def;

    def = new MessageDef("LogonRequested", this);
    defs.addElement(def);

    def = new MessageDef("ExitSystem", this);
    defs.addElement(def);

    return defs;
}
//---------- MessageListener Implementation --------------
public void processMessage(Message message) {
    String name = message.getName();
    //print(".processMessage() - name = '" + name + "'");

    if (name == "LogonApproved") {
        // *** user = (User)message.get("User");
        if (systemMenu.isVisible()) systemMenu.resetParam();       
        systemMenu.setVisible(true);
        startInfoBar(message.getString("UserID"));
        isSystemStarted = true;

    } else if (name == "LogonCancelled") {
        if (isSystemStarted) {
            // Do nothing, user has cancelled a logoff
        } else {
            closeEntireSystem();
        }
    } else if (name == "Logoff") {
        messageRouter.fire("LogonRequested", this);

    } else if (name == "ExitSystem") {
        exitSystemRequested();

    } else {
        // We do not handle all we receive
        print(".processMessage() - Unhandled messageName " + name);
    }
    //print(".processMessage() - Leaving");
}
public String[] loadMessageInterests() {
    return new String[] {"LogonApproved", "LogonCancelled",
        "Logoff", "ExitSystem"};
}
//---------- BeanPriv Implementation ---------------------
// For later use in command args, etc
public void setBasketServices(BasketServices services) {
    basketServices = services;
}
//---------- BeanActionStart Implementation --------------
// System entry point <-----<<<
public void start() {
    messageRouter.fire("LogonRequested", this);
}
//---------- Properties ----------------------------------
public void setSystemMenu(MenuFramePD systemMenu) {
    this.systemMenu = systemMenu;
}
//---------- Private Methods -----------------------------
private void startInfoBar(String userID) {
    // Prepare infoBar
    infoBar = new InfoBar();
    infoBar.setText("Logon successful for " + userID + ".");
    infoBar.setVisible(true);

    // Hookup infoBar, WindowMgr to global Hub
    Hub.getGlobalRouter().addListenerInterests(infoBar);

    // *** Not used, bug causes activated window to loose
    // focus when InfoBar window.toFront() is called.
    // Bug 4092033, "toFront() is also setting focus"
    // is marked "In progress, bug" as of 6/26/98
    // Once this is fixed, try uncommenting the following:
    //WindowMgr.setSendingGlobalEvents(true);
}
// Formerly done by org.jcon.ba.lib.SystemCloser
private void exitSystemRequested() {
    // Can the root, ie entire system, be closed?
    String reason = basketServices.canCloseItem("this");
    if (reason != null) {
        GenLib.helpfulHint("Sorry, cannot close now because:"
            + "\n" + reason);
        return;
    }
    // Confirm
    MessageBox box = new MessageBox();
    box.setTitle("Exit System Confirmation");
    box.addChoice("Yes");
    box.addChoice("No");
    box.setCloseWindowCommand("No");
    String answer = box.askBlock("Proceed to exit the system?");

    if (answer == "Yes") closeEntireSystem();
}
private void closeEntireSystem() {
    if (basketServices != null) basketServices.closeItem("this");
    if (infoBar != null)        infoBar.close();
    System.exit(0);
}
//--- Std
private static void print(String text) {
    System.out.println("Mediator" + text);
}

} // End class