package gov.cdc.atsdr.client;

import org.jcon.ba.system.ItemSystemMgr;


/**
 * The client entry point and marker class, similar to
 * DataClient but through RMI.
 * <p>
 * Note we implement Runnable, which is on all clients.
 *
 * @author Jack Harich
 */
public class EntryPoint implements Runnable {

//---------- Initialization ------------------------------
// For manual testing
public static void main(String args[]) {
    new EntryPoint().run();
}
//---------- Runnable Implementation ---------------------
/**
 * Since this class originated on the server, classes it
 * references will be loaded from the server via the RMI
 * classloader, if the classes are not on the client.
 * For example this is how ItemSystemMgr is loaded.
 */
public void run() {
	new ItemSystemMgr().startSystem(this, null);
}



} // End class