package gov.cdc.atsdr.client;

import org.jcon.ui.DelayWindow;
import org.jcon.ui.OutputConsole;
import org.jcon.ba.system.ItemSystemMgr;

/**
 * The DataClient entry point and marker class.
 *
 * @author Jack Harich
 */  // java -nojit gov.cdc.atsdr.client.DataClient

public class DataClient {
    
//---------- Initialization ------------------------------
// Any arg to open console
public static void main(String args[]) {
    if (args.length > 0) {
        new OutputConsole().setVisible(true);
    }
    // Start delay window
    DelayWindow delayWindow = new DelayWindow();
    delayWindow.setTitle("Starting the ATSDR System");
    delayWindow.setMessage("Initializing parameter driven classes,\n" +
        "hooking up to server database\n" +
        "and preparing visual libraries.");
    delayWindow.start();
    
    // Start sytsem
	new ItemSystemMgr().startSystem(new DataClient(), args);
    
    // Stop delay window
    delayWindow.close();
}


} // End class