package gov.cdc.atsdr.client;

import org.jcon.util.minor.BetterRMISecurityManager;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.server.RMIClassLoader;

/**
 * The client bootstrap entry point. This class is designed
 * to NEVER need replacing, to allow thin client. It gets
 * and starts a named entry point program from the server
 * via RMI.
 * <p>
 * To start the client use the command: <pre>
 *      javaw org.jcon.test.rmi.Bootstrap <optional args> </pre>
 * "java" rather than "javaw" may be used for testing.
 * <p>
 * We use the mechanism described in the RMI Spec, section
 * "System Architecture", topic "Dynamic Class Loading",
 * subtopic "BootStrapping the Client".
 * <p>
 * To run the app the thin client needs: <pre>
 * - The Java 1.1 JRE or JDK
 * - This class or an applet calling this class
 * - BetterRMISecurityManager if an application
 * </pre>
 *
 * @author Jack Harich *** REUSABLE ***
 */
public class Bootstrap {

//---------- Private Fields ------------------------------
String urlString = "http://sheba/awork/";
String className = "gov.cdc.atsdr.client.EntryPoint";

//---------- Initialization ------------------------------
/**
 * Allows Bootstrap to be run from the command line.
 * Optional args are URL and ClassName. To provide the
 * second the first must also be provided.
 */
public static void main(String args[]) {
    Bootstrap bootstrap = new Bootstrap();
    if (args.length > 0) bootstrap.setURL(args[0]);
    if (args.length > 1) bootstrap.setClassName(args[1]);
    bootstrap.runClass();
}
//---------- Properties ----------------------------------
/**
 * Sets the URL property. The default is "http://sheba/awork/".
 */
public void setURL(String url) {
    urlString = url;
}
/**
 * Sets the ClassName. The default is "org.jcon.test.rmi.EntryPoint".
 */
public void setClassName(String className) {
    this.className = className;
}
//---------- Public Methods ------------------------------
public void runClass() {

try {
    // Requires BetterRMISecurityManager if application.
    //if (System.getSecurityManager() == null) {
        print("Setting SecurityManager");
        System.setSecurityManager(new BetterRMISecurityManager());
    //}
    // Get instance from server via RMI
    URL url = new URL(urlString);

    print("URL = " + url + ", class = " + className);
    print("Loading entry point via RMIClassLoader, please wait...");
    Class clas = RMIClassLoader.loadClass(url, className);
    print("The class loaded is: " + clas);

    Runnable entryPoint = (Runnable)clas.newInstance();

    // Start entry point
    print("Entry point received, about to run it.");
    entryPoint.run();

    print("Entry point complete.");

} catch(Exception ex) {
    print("Bootstrap has failed");
    ex.printStackTrace();
}
} // End method

//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println(text);
}


} // End class