package gov.cdc.atsdr;

import org.jcon.param.util.ConfigParamFiles;

/**
 * This class configures parex files for a release.
 * It should be run for each new release. See the
 * companion parex file.
 *
 * @author Jack Harich
 */ // java gov.cdc.atsdr.ConfigRelease
public class ConfigRelease {

//---------- Initialization ------------------------------
/**
 * Runs this class. If any arguments are used then they are
 * the param file names used. If no arguments are used then
 * the file "ConfigRelease.parex" is used.
 */
public static void main(String resourceNames[]) {

    if (resourceNames.length == 0) {
        resourceNames = new String[] {"ConfigRelease.parex"};
    }
    new ConfigRelease().modify(resourceNames);
}
//---------- Public Methods ------------------------------
public void modify(String resourceNames[]) {
    ConfigParamFiles modifier = new ConfigParamFiles();
    modifier.modifyResources(this, resourceNames);
}
//--- Std
private static void print(String text) {
    System.out.println("ConfigRelease" + text);
}

} // End class