package org.jcon.util.setting;

import org.jcon.param.Param;
import org.jcon.param.ParamDriven;
import org.jcon.param.ParamDrivenInfo;
import java.util.Hashtable;

/**
 * This class manages a collection of SettingTypes. There
 * is currently one collection per database.
 *
 * @author Jack Harich
 */
public class SettingTypeMgr implements ParamDriven {

//---------- Private Fields ------------------------------
private Param  param;

// Key = name, Object = SettingType
private Hashtable settingTypes = new Hashtable();

//---------- ParamDriven Implementation ------------------
public void setParam(Param param) {
    this.param = param;
    // Init myself. Support multiple calls.
    settingTypes.clear();
    
    Param typesParam = param.getParam("SettingTypes");
    String[] names = typesParam.getDataKeys();
    for (int i = 0; i < names.length; i++) {
    	String name = names[i];
        //print(".setParam() - Adding name " + name);
    	Param typeParam = typesParam.getParam(name);
		SettingType type = new SettingType(name, typeParam);
		settingTypes.put(name, type);
    }
}
public Param getParam() {
    return param;
}
public boolean applyNewParam(Param newParam) {
    setParam(newParam);
    return true; // Successful
}
public ParamDrivenInfo getParamDrivenInfo() {
    return null;
}
//---------- Properties ----------------------------------

//---------- Public Methods ------------------------------
public SettingType getSettingType(String name) {
	SettingType type = (SettingType)settingTypes.get(name);	
	if (type == null) throw new IllegalArgumentException(
		"SettingType name '" + name + "' not found.");
	return type;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("SettingTypeMgr" + text);
}

} // End class
