package org.jcon.util.setting;

import org.jcon.df.column.ColumnDef;
import org.jcon.df.column.ColumnDefFactory;
import org.jcon.param.Param;

/**
 * This class defines a setting type, which is similar to a
 * "datatype". SettingTypes are reused to form SettingDefs,
 * since each SettingDef has one SettingType.
 * The SettingType properties are: <p> <pre>
 * Required:
 *		Name, ColumnDef
 * Optional:
 *		Required - Default false
 *		Description
 *		InitialValue
 * </pre> <p>
 * @author Jack Harich
 */
public class SettingType {

//---------- Private Fields ------------------------------
private String    name;
private ColumnDef columnDef;

private boolean   required;
private String    description;
private String    initialValue;

//---------- Initialization ------------------------------
public SettingType(String name, Param param) {
    // Required
    this.name = name;
		
    Param columnDefParam = param.getParam("ColumnDef");
    columnDef = ColumnDefFactory.create(name, columnDefParam);
		
    // Optional
    required = param.isTrueDefaultFalse("Required");
    description = param.getString("Description");
    initialValue = param.getString("InitialValue");
}
//---------- Properties ----------------------------------
//----- Required getters
public String getName() {
    return name;
}
public ColumnDef getColumnDef() {
    return columnDef;
}
//----- Optional getters
public boolean isRequired() {
    return required;
}
public String getDescription() {
    return description;
}
public String getInitialValue() {
    return initialValue;
}
//---------- Public Methods ------------------------------
/**
 * Validates the value. Returns null for
 * okay or a String explaining the problem.
 */
public String validate(String value) {
    return columnDef.validate(value);
} 
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("SettingType" + text);
}

} // End class
