package org.jcon.util.setting;


/**
 * This interface defines the persistent source for
 * settings. This is a plugpoint interface allowing the
 * setting subsystem to use any persistent source.
 *
 * @author Jack Harich
 */
public interface SettingSource {


/**
 * Reads the named setting and returns the result in
 * ReadValueResponse. 
 */
public ReadSettingResponse readSetting(String name);

/**
 * Adds the initial setting to storage. Returns null for
 * success or a String explaining the problem.
 */
public String addInitialSetting(String name, String initialValue);


} // End interface
