package org.jcon.util.setting;

import org.jcon.param.util.build.BuildParamEvent;
import org.jcon.param.util.build.BuildParamListener;
import org.jcon.util.DataLib;
import java.util.Vector;

/**
* This class is a single configurable setting, used for
* replacing lines of text in Param text. It replaces a
* single setting with zero or more lines.
*
* @author Jack Harich
*/
public class SettingLines implements BuildParamListener {

//---------- Private Fields ------------------------------
//----- Properties
private String buildParamKey;

//----- Internal
private Vector lines = new Vector();

//---------- BuildParamListener Implementation -----------
public String[] getBuildParamKeys() {
    //print(".getBuildParamKey() - key = " + buildParamKey);
    if (buildParamKey == null) {
        return new String[0];
    } else {
        return new String[] { buildParamKey };
    }    
}
public void processBuildParamEvent(BuildParamEvent evt) {
    // We do not use a value, but replace the setting
    // with all the lines. Thus the value is irrelevant.
    String textLines = DataLib.convertVectorToDelimString(lines, "\n");
    evt.setReplacement(textLines);
    //print(".processBuildParamEvent() - lines: \n" + textLines);
}
//---------- Properties ----------------------------------
/**
* Sets the BuildParamKey that this setting will respond to.
*/
public void setBuildParamKey(String buildParamKey) {
    this.buildParamKey = buildParamKey;
    //print(".setBuildParamKey() - key = " + buildParamKey);
}
public String getBuildParamKey() {
    return buildParamKey;
}
//---------- Public Methods ------------------------------
/**
* Adds a line of text. All the lines will be used as the
* value for this setting. Spaces are honored.
*/
public void addLine(String line) {
    lines.addElement(line);
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("SettingLines" + text);
}

} // End class
