package org.jcon.util.setting;

import org.jcon.util.setting.SettingSource; 

/**
 * This class contains the response to a readSetting().
 *
 * @author Jack Harich
 */
public class ReadSettingResponse implements java.io.Serializable {

//---------- Public Fields -------------------------------
public static final int EXCEPTION       = 1;
public static final int NOT_IN_DATABASE = 2;
public static final int IN_DATABASE     = 3;

//---------- Private Fields ------------------------------
private int       responseType;
private String    value;
private String    failureText;
private Exception failureException;

//---------- Initialization ------------------------------
public ReadSettingResponse(int responseType) {
    
    if (responseType == EXCEPTION ||
        responseType == NOT_IN_DATABASE ||
        responseType == IN_DATABASE) {
            this.responseType = responseType;
            
    } else {
        throw new IllegalArgumentException(
            responseType + " is not a valid response type.");  
    }
}
//---------- Properties ----------------------------------
public int getResponseType() {
    return responseType;    
}
//----- value
public void setValue(String value) {
    this.value = value;    
}
public String getValue() {
    return value;    
}
//----- failureText
public void setFailureText(String failureText) {
    this.failureText = failureText;    
}
public String getFailureText() {
    return failureText;    
}
//----- failureException
public void setFailureException(Exception exception) {
    failureException = exception;    
}
public Exception getFailureException() {
    return failureException;    
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ReadSettingResponse" + text);
}

} // End class
