package org.jcon.util.setting;

import org.jcon.ui.VisualLib;
import org.jcon.ui.WindowLib;
import org.jcon.ui.WindowMgr;
import org.jcon.ui.easylayout.EasyLayout;
import org.jcon.ui.easylayout.EasyLayoutRegistry;
import org.jcon.ui.easylayout.EasyLayoutLibraryStd;
import java.awt.*;
import java.awt.event.*;

/**
 * This class provides the view.
 *
 * @author Jack Harich
 */
public class EditLocalSettingView implements
    ActionListener, WindowListener {

//---------- Private Fields ------------------------------
// Properties
private EditLocalSetting controller;
private String     title;
private String     settingName;
private int        fieldSize = 20;
// Working
private Frame      window;
private EasyLayout easyLayout;

private Label      editLbl;
private TextField  editValueTfd;
private TextField  localValueTfd;
private TextField  actualValueTfd;
private TextField  settingNameTfd;

private static final String STYLE_LIBRARY = "org.jcon.Standard";

//---------- Initialization ------------------------------
public void init() {
    // Prepare window *** Mod to use PrimeWindow *********
    window = WindowMgr.createRegisteredFrame();
    window.setTitle(title);
    window.setBackground(Color.lightGray);
    window.addWindowListener(this);
    
    // Init easyLayout
    // *** Need better way to do this once in root ***
    // Useful here for unit test
    // Also done in DataView
    if (! EasyLayoutRegistry.hasLibrary(STYLE_LIBRARY)) {
        EasyLayoutRegistry.addLibrary(STYLE_LIBRARY, new EasyLayoutLibraryStd());        
    }
    easyLayout = EasyLayoutRegistry.createLayout(STYLE_LIBRARY);
    easyLayout.setTopContainer(window);
    
    // Add rows
    editLbl = new Label();
    editValueTfd = new TextField(fieldSize);
    localValueTfd = new TextField(fieldSize);
    localValueTfd.setEditable(false);
    localValueTfd.setBackground(Color.cyan);
    actualValueTfd = new TextField(fieldSize);
    actualValueTfd.setEditable(false);
    settingNameTfd = new TextField(40);
    settingNameTfd.setEditable(false);
    settingNameTfd.setText(settingName);
    
    //addRow(editLbl,   editValueTfd);
    addRow("Enter New Value",   editValueTfd);
    addRow("Current Local Value",  localValueTfd);
    addRow("System Value", actualValueTfd);
    addRow("Setting Name", settingNameTfd);
    
    // Add buttons
    Panel buttonBar = new Panel();
    buttonBar.add(createButton("Change Local Value", "ChangeLocalValue"));
    buttonBar.add(createButton("Revert to System Value", "RevertToActualValue"));
    buttonBar.add(createButton("Close", "Close"));
    easyLayout.add(buttonBar, "BottomBar", "EndRow");
}    
// Same layout as in RowFieldPanel
private void addRow(Label label, TextField textField) {
    easyLayout.add(label, "FieldRight", null);
    easyLayout.add(textField, "FieldLeft", "EndRow");    
}    
private void addRow(String text, TextField textField) {
    easyLayout.add(new Label(text), "FieldRight", null);
    easyLayout.add(textField, "FieldLeft", "EndRow");
}
private Button createButton(String text, String command) {
     Button button = new Button(text);
     button.setActionCommand(command);
     button.addActionListener(this);
     return button;   
}    
//---------- ActionListener Implementation ---------------
public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand().intern();
    //print(".actionPerformed() - " + command);
    if (command == "ChangeLocalValue") {
         controller.changeLocalValueCmd();   
    } else if (command == "RevertToActualValue") {
         controller.revertToActualValueCmd();   
    } else if (command == "Close") {
         controller.closeCmd();
    } else {
         print(".actionPerformed() - Unknown command " + command);   
    }
}    
//---------- WindowListener Implementatons ---------------
public void windowClosing(WindowEvent evt) {
    // User clicked on X or chose window Close
    controller.closeCmd();
}
public void windowClosed(WindowEvent evt) { }
public void windowDeiconified(WindowEvent evt) { }
public void windowIconified(WindowEvent evt) { }
public void windowOpened(WindowEvent evt) { }
public void windowActivated(WindowEvent evt) {  }
public void windowDeactivated(WindowEvent evt) { }

//---------- Properties ----------------------------------
public void setController(EditLocalSetting controller) {
     this.controller = controller;   
}    
//----- title
public void setTitle(String title) {
     this.title = title;   
}    
public String getTitle() {
     return title;   
}
//----- settingName
public void setSettingName(String settingName) {
     this.settingName = settingName; 
}    
public String getSettingName() {
     return settingName;   
}    
//----- fieldSize
public void setFieldSize(int fieldSize) {
    this.fieldSize = fieldSize;    
}
public int getFieldSize() {
     return fieldSize;   
}    
//----- visible
public void setVisible(boolean visible) {
    if (visible) {
        window.pack();
        WindowLib.center(window);
    }
    window.setVisible(true);
}
public boolean isVisible() {
    if (window == null) {
        return false;
    } else {
        return window.isVisible();
    }            
}    
//----- editLabel
public void setEditLabel(String editLabel) {
     editLbl.setText(editLabel);   
}    
//----- editValue
public void setEditValue(String editValue) {
    editValueTfd.setText(editValue);
}  
public String getEditValue() {
     return editValueTfd.getText();   
}  
//----- localValue
public void setLocalValue(String localValue) {
    localValueTfd.setText(localValue);
}  
public String getLocalValue() {
     return localValueTfd.getText();   
}  
//----- actualValue
public void setActualValue(String actualValue) {
    actualValueTfd.setText(actualValue);
}  
public String getActualValue() {
     return actualValueTfd.getText();   
}  
//---------- Public Methods ------------------------------
public void requestFocusEditValue() {
     editValueTfd.requestFocus();   
}    
// Revert to restartable state
public void close() {
    if (window != null) {
         window.dispose();
         window = null;   
    }
}       
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("EditLocalSettingView" + text);
}

} // End class
