package org.jcon.util.service;

/**
 * The interface for ContainerServices users. This allows
 * a container to provide services to those members
 * who need them.
 *
 * @author Jack Harich
 */
public interface ContainerServicesUser {


/**
 * Sets the services the user had implied they need by
 * implementing this interface.
 */
public void setContainerServices(ContainerServices services);

/**
 * Returns the service names the user is interested in.
 * These are the services it may be using. This is designed
 * for a variety of potential uses, such as: <p> <pre>
 * - Assuring the services are available.
 * - Inspecting a collection of workers to see exactly
 *      where certain services are used. 
 * - Visually displaying the network of services, their
 *      users, and the paths involved. </pre>
 */
public String[] getContainerServicesInterests();

// Future
// public Vector getContainerServicesMessageDefs();



} // End interface


/**

import org.jcon.util.service.ContainerServices;
import org.jcon.util.service.ContainerServicesUser;

//---------- ContainerServicesUser Implementation --------
public void setContainerServices(ContainerServices services) {
    containerServices = services;
}
public String[] getContainerServicesInterests() {
    return new String[] {"SoAndSoService"}; 
}

*/
