package org.jcon.util.msg;

import java.util.Vector;

/**
 * An abstract class providing a default implementation of
 * MessageSource. See MessageSource for documentation.
 *
 * @author Jack Harich
 */
public abstract class MessageSourceStd
    implements MessageSource {

//---------- Protected Fields ----------------------------
protected MessageRouter messageRouter = new MessageRouter(this);

//---------- MessageSource Implementation ----------------
public void addMessageListener(String eventName, MessageListener listener) {
    messageRouter.addListener(eventName, listener);
}
public void removeMessageListener(String eventName, MessageListener listener) {
    messageRouter.removeListener(eventName, listener);
}
public MessageRouter getMessageRouter() {
    return messageRouter;
}

// Template method
public abstract Vector getMessageDefs();


} // End class

/*

import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageDef;
import org.jcon.util.msg.MessageSourceStd;
import java.util.Vector;

//---------- MessageSourceStd Abstract Implementations ---
public Vector getMessageDefs() {
    Vector defs = new Vector();
    MessageDef def;
    
    // *** An example ***
    def = new MessageDef(START_DEVICE_TAB, this);
    def.add("WidgetSet", WidgetSet.class, "Contains Devices tab widgets.");
    defs.addElement(def);     
        
    return defs;
}

*/