package org.jcon.util.msg;

import java.util.Vector;

public interface MessageSource {

/**
* The interface for sources of Message events. A source
* fires Message events to its listeners using its
* MessageRouter.
* <p>
* Note these are named Messages. This differs from the
* bean spec but appears to be far more reusable, and is an
* easy way to implement events. We have a reusable event,
* listener, source and multicaster. Zowee!
* <p>
* Note that usually a class extends MessageSourceStd
* rather than implementing this interface.
*
* @author Jack Harich
*/

/**
 * The constant used for an eventName to listen for all
 * events. This is much cleaner than using null.
 */
public static final String ALL_EVENTS = "AllEvents";

/**
 * Adds the listener for the named event. They will be
 * notified when a Message with this eventName is fired.
 * If eventName == ALL_EVENTS then that listener will
 * receive all events.
 */
public void addMessageListener(String eventName, MessageListener listener);

/**
 * Removes the listener for the named event. If ALL_EVENTS
 * was used to add the listener then it must be used to
 * remove the listener. There is no effect if the listener
 * is not subscribed to the eventName.
 */
public void removeMessageListener(String eventName, MessageListener listener);

/**
 * Returns the message router used for subscribing message
 * listeners and firing messages. The router can be queried
 * for various info, such as listeners. It can also be asked
 * for notification of events.
 */
public MessageRouter getMessageRouter();

/**
 * Returns a Vector of MessageDefs, each of which represents
 * one event type this source may fire. This replaces the
 * introspection that normally used to determine what events
 * a bean fires. Note these may be dynamic, such as in the
 * case of a dynamic container or routing service.
 */
public Vector getMessageDefs();


} // End interface

/*

import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageDef;
import org.jcon.util.msg.MessageListener;
import org.jcon.util.msg.MessageRouter;
import org.jcon.util.msg.MessageSource;
import java.util.Vector;

private MessageRouter messageRouter = new MessageRouter();

//---------- MessageSource Implementation ----------------
public void addMessageListener(String eventName, MessageListener listener) {
    messageRouter.addListener(eventName, listener);
}
public void removeMessageListener(String eventName, MessageListener listener) {
    messageRouter.removeListener(eventName, listener);
}
public MessageRouter getMessageRouter() {
    return messageRouter;
}
public Vector getMessageDefs() {
    Vector defs = new Vector();
    MessageDef def;
    
    def = new MessageDef(START_DEVICE_TAB, this);
    def.add("WidgetSet", WidgetSet.class, "Contains Devices tab widgets.");
    defs.addElement(def);     
        
    return defs;
}

*/