package org.jcon.util.msg;

/**
* A Message service processes particular Messages,
* notably acquire type Messages. This interface
* allows a service type architecture with looser
* coupling by use of Messages.
*
* @author Jack Harich
*/
public interface MessageService {

/**
* The listener should process the message. If the message
* is unwanted it may complain but should not throw an
* exception.
*/
public void serviceMessage(Message message);

/**
* Returns an array of the MessageDefs processed.
*/
public MessageDef[] getServiceMessageDefs();

} // End interface


/**

import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageProcessor;
import java.util.Vector;

//---------- MessageService Implementation --------------
public void serviceMessage(Message message) {
    String messageName = message.getName();

    if (messageName == "ThisHappened") {
        thisHappened(message.get("What"));

    } else if(messageName == "ThatHappened") {
        thatHappened();

    } else {
        print(".processMessage() - Unknown messageName '" + messageName + "'");
    }
}
public MessageDef[] getServiceMessageDefs() {
    // *** do
}


*/
