package org.jcon.util.msg;

/**
 * The interface for Message listeners.
 *
 * @author Jack Harich
 */
public interface MessageListener {

/**
 * The listener should process the event. If the event
 * is unwanted it may complain but should not throw an
 * exception.
 */
public void processMessage(Message message);

/**
 * The listener should return an array of the message names
 * of interest. These are the message names it will handle
 * in processMessage(). "load" instead of "get" is used
 * since this is not a property.
 */
public String[] loadMessageInterests();

} // End interface 


/**

import org.jcon.util.msg.Message;
import org.jcon.util.msg.MessageListener;

//---------- MessageListener Implementation --------------
public void processMessage(Message message) {
    String messageName = message.getName();

    if (messageName == "ThisHappened") {
        thisHappened(message.get("What"));

    } else if(messageName == "ThatHappened") {
        thatHappened();

    } else {
        print(".processMessage() - Unknown messageName '" + messageName + "'");
    }
}
public String[] loadMessageInterests() {
    return new String[] {"ThisHappened", "ThatHappened"};
}


*/
