package org.jcon.util.msg;

/**
 * Represents one unique source/event/listener combination.
 * If the system is working properly then when the source
 * fires the event a Message like the MessageDef will be
 * delivered to the listener.
 *
 * @author Jack Harich
 */
public class MessageLink implements Cloneable {

//---------- Private Fields ------------------------------
private String          eventName;  // Required
private MessageListener listener;   // null if none
private Object          source;     // null if none
private MessageDef      messageDef; // null if no source

//---------- Initialization ------------------------------
public MessageLink(String eventName) {
    this.eventName = eventName;
}
public MessageLink(String eventName, MessageListener listener) {
    this.eventName = eventName;
    this.listener = listener;
}
//---------- Superclass Overrides ------------------------
public Object clone() {
    MessageLink link = new MessageLink(eventName, listener);
    link.setSource(source);
    link.setMessageDef(messageDef);
    return link;
}
//---------- Public Methods ------------------------------
public String getEventName() {
    return eventName;
}
//----- Listener
public boolean hasListener() {
    return (listener != null ? true : false);
}
public MessageListener getListener() {
    return listener;
}
public void setListener(MessageListener listener) {
    this.listener = listener;
}
//----- Source
public boolean hasSource() {
    return (source != null ? true : false);
}
public Object getSource() {
    return source;
}
public void setSource(Object source) {
    this.source = source;
}
//----- MessageDef
public boolean hasMessageDef() {
    return (messageDef != null ? true : false);
}
public MessageDef getMessageDef() {
    return messageDef;
}
public void setMessageDef(MessageDef messageDef) {
    this.messageDef = messageDef;
}
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println(text);
}

} // End class
