package org.jcon.util.msg;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * Defines a Message event by containing the message event
 * name, source class name and properties. Each property
 * has a name, class type and description. This class is
 * useful for querying a Hub or a particular MessageSource.
 *
 * @author Jack Harich
 */
public class MessageDef {

//---------- Private Fields ------------------------------
private String  eventName;
private String  sourceClassName;

// Simpler to use two Hashtables rather than inner class
private Hashtable propTypes = new Hashtable();
private Hashtable propDescriptions = new Hashtable();

//---------- Initialization ------------------------------
public MessageDef(String eventName, Object source) {
    this.eventName = eventName;
    sourceClassName = source.getClass().getName();
}
//---------- Public Methods ------------------------------
//----- Setters
/**
 * Adds a property. Short method name since widely used.
 */
public void add(String propertyName, Class type,
            String description) {
    propTypes.put(propertyName, type);
    propDescriptions.put(propertyName, description);
}
//----- Getters
public String getEventName() {
    return eventName;
}
public String getSourceClassName() {
    return sourceClassName;
}
public String[] getPropertyNames() {
    String[] names = new String[propTypes.size()];
    int count = 0;
    Enumeration keys = propTypes.keys();
    while (keys.hasMoreElements() ) {
        names[count++] = (String)keys.nextElement();
    }
    return names;
}
public Class getPropertyType(String key) {
    return (Class)propTypes.get(key);
}
public String getPropertyDescription(String key) {
    return (String)propDescriptions.get(key);
}


} // End class
