package org.jcon.util.minor;

import java.rmi.RMISecurityManager;

/**
 * A slightly modified RMISecurityManager to fix apparent
 * bugs in the RMI Bootstraping Spec. By Joel Riedesel at
 * jriedese@jnana.com 5/28/98 in response to question on
 * RMI Users List. The bug was:
 * <p> <pre>
 * java.rmi.RMISecurityException: security.threadgroup
 *   at java.rmi.RMISecurityManager.checkAccess(RMISecurityManager.java:92)
 *   at java.lang.ThreadGroup.checkAccess(ThreadGroup.java:271)
 *   at java.lang.ThreadGroup.<init>(ThreadGroup.java:109)
 *   at sun.rmi.transport.RMIThread.getThreadGroup(RMIThread.java:84)
 *   at sun.rmi.transport.RMIThread.newThread(RMIThread.java:45)
 *   at sun.rmi.transport.proxy.RMIMasterSocketFactory.createSocket(RMIMasterSocketFactory.java:141)
 *   at sun.rmi.transport.tcp.TCPChannel.openSocket(TCPChannel.java:236)
 *   at sun.rmi.transport.tcp.TCPChannel.newConnection(TCPChannel.java:125)
 *   at sun.rmi.server.UnicastRef.newCall(UnicastRef.java:73)
 *   at sun.rmi.registry.RegistryImpl_Stub.lookup(RegistryImpl_Stub.java:86)
 *   at java.rmi.Naming.lookup(Naming.java:60)
 *   at org.jcon.test.rmi.EntryPoint.lookupRemoteDatastore(EntryPoint.java:53)
 *   at org.jcon.test.rmi.EntryPoint.run(EntryPoint.java:34)
 * (/pre>
 * @author Joel Riedesel
 */
public class BetterRMISecurityManager extends RMISecurityManager {

//---------- Superclass Overrides ------------------------
// Overriding these cures the above bug.
public void checkAccess(Thread t) {}
public void checkAccess(ThreadGroup tg) {}
public void checkRead(String fname) {}

// This allows opening a direct JDBC connection
public void checkWrite(String file) {}

// This allows exiting
public synchronized void checkExit(int status) {}

// Prevents "Warning: Applet Window" on windows
public synchronized boolean checkTopLevelWindow(Object window) {
    return true;
}


} // End class
//============ From N. J. O'Neill  njoneill@LLNL.GOV  5/29/98
/**
You may have to relax the security policies even more depending on what your
bootstrapped client wants to do.  For a client that has a GUI, uses RMI, uses
the clipboard, reads/writes files, and accesses system properties, I had to
override the following additional methods:

        public void checkWrite(String file) {}
        public void checkExit(int status) {}
        public boolean checkTopLevelWindow(Object window) {return true; }
        public void checkAwtEventQueueAccess() {}
        public void checkSystemClipboardAccess() {}
        public synchronized void checkConnect(String host, int port) {}
        public void checkPropertyAccess(String key) {}
        public void checkWrite(FileDescriptor fd) {}

Of course, at this point security has pretty much been thrown out the window
and it's probably time to start looking into how to use
java.security.SecureClassLoader which will be available in  JDK 1.2.
*/
