package org.jcon.util.log;

import org.jcon.util.GenLib;

/**
 * The log subsystem unit test. 
 *
 * @author Jack Harich
 */  // java org.jcon.util.log.UnitTest false
     
public class UnitTest {

//---------- Private Fields ------------------------------
private String         resource = "UnitTest.txt";
private ProblemHandler problemHandler = new ProblemHandler();

//---------- Initialization ------------------------------
/**
* Starts the test. If no args the test displays the problem.
* If the first arg is "true" or "false" then that determines
* whether problems are displayed or not. Case insensitive.
*/
public static void main(String args[]) {
    boolean displayProblem = true;
    if (args.length > 0) {
        String arg = args[0].toLowerCase().intern();
        if (arg == "true") {
            displayProblem = true;
        } else if (arg == "false") {
            displayProblem = false;
        } else {
            print(" - Argument must be 'true' or 'false'");
            print(" - Test aborted");
            return;   
        }
    }
    new UnitTest().start(displayProblem);    
}    
//---------- Public Methods ------------------------------
/**
* Starts the test.
*
* @param displayProblem  true to display problems, false to
* never display problems. This allows running the log 
* subsystem with no GUI, which is useful on unattended servers.
*/
public void start(boolean displayProblem) {
    print(" - Starting test");
    //----- Init problemHandler
    // required properties
    problemHandler.setMarkerClass(this.getClass().getName());
    problemHandler.setResource(resource);
    // Optional properties
    problemHandler.setDisplayProblem(displayProblem);
    problemHandler.hookupToGenLib();

    //----- Log error
    GenLib.error("UnitTest.start()", "Test error");
    GenLib.exception("UnitTest.start()", "Test exception",
        new IllegalArgumentException("Bad argument"));
    
    print(" - Test complete");
    System.exit(0);
}    
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("UnitTest" + text);
}

} // End class
