package org.jcon.util.log;

import org.jcon.util.GenLib;

/**
* This class provides a simple command line administrative 
* tool for viewing and emptying the log. 
*
* @author Jack Harich
*/  

// java org.jcon.util.log.SimpleLogAdmin org.jcon.util.log.UnitTest UnitTest.txt review
    
public class SimpleLogAdmin { 

//---------- Private Fields ------------------------------ 
private String markerClass;
private String resource; 
/**@supplierCardinality 1*/
private Logger logger = new Logger();
                                                   
//---------- Initialization ------------------------------
/**
* See start(args) for documentation.
*/
public static void main(String[] args) {
    new SimpleLogAdmin().start(args);          
}  
//---------- Properties ----------------------------------
//----- markerClass
public void setMarkerClass(String markerClass) {
    logger.setMarkerClass(markerClass);
}                  
public String getMarkerClass() {
    return logger.getMarkerClass();
}                      
//----- resource
public void setResource(String resource) {
    logger.setResource(resource);
}                            
public String getResource() {
    return logger.getResource();
}
//---------- Public Methods ------------------------------
/**
* This starts the tool. Three arguments are required.
* The first and second args must be the marker class and
* resource used in the Logger to create the log file.
* <p>
* Supported third arguments are: <p> <pre>
* "review" - Reviews the log, pausing after each entry.
* "empty" - Allows the log to be emptied after a Yes/No choice.
* "count" - Returns the count of log items. This is the default arg.
* </pre> <p>
*/
public void start(String args[]) {
    if (args.length < 3) {
        print(" - First and second args must be MarkerClass and Resource.");
        print(" - Third arg must be 'review', 'empty' or 'count'.");
        return;
    }        
    setMarkerClass(args[0]);
    setResource(args[1]);
    String command = args[2].intern();
    
    if (command == "review") {
        reviewLog();
    } else if (command == "empty") {
        emptyLog();
    } else if (command == "count") { 
        countLog();    
    }     
}    
/**
* This provides a simple command line review of the log,
* pausing after each item. ENTER shows the next item,
* STOP stops showing items.
*/
public void reviewLog() {
    String[] items = countLog();
    String separator = "---------------";
    System.out.println(separator + " Items " + separator);
    for (int i = 0; i < items.length; i++) {
        System.out.print(items[i]);
        String command = GenLib.readInputLine(separator + 
            " " + (i + 1) + " of " + items.length + " " + separator + " ");
        if (command.equalsIgnoreCase("stop")) break;
    }    
    print(" - Review complete."); 
} 

public void emptyLog() {
    countLog();
    String answer = GenLib.readInputLine("Empty the log? (Yes or No): ");
    if (! answer.equals("Yes")) return;
    
    String answer2 = GenLib.readInputLine("Do you really want to empty the log? (Yes or No): ");
    if (answer2.equals("Yes")) {
        boolean successful = logger.emptyLog();
        if (successful) {
            print(" - Log is now empty.");
        } else {
            print(" - EmptyLog has failed. Please investigate.  :-)");        
        }
    }             
}                
public String[] countLog() {
    System.out.println();
    String[] items = logger.listItems();
    print(" - " + items.length + " items are in the log.");
    return items;
}
//---------- Private Methods -----------------------------   
//--- Std
private static void print(String text) {
    System.out.println("SimpleLogAdmin" + text);
}                                
 
} // End class





