package org.jcon.util.log;

import org.jcon.util.GenLib;
import org.jcon.util.ProblemController;

/**
 * This class handles "problems", which are system errors
 * and exceptions. Note the MarkerClass and Resource are
 * required.
 *
 * @author Jack Harich
 */
public class ProblemHandler implements ProblemController {

//---------- Private Fields ------------------------------
private Logger  logger = new Logger();
private boolean displayProblem;

//---------- ProblemController Implementation ------------
public void processError(String methodID, String message) {
    Problem problem = new Problem();
    problem.setMethodID(methodID);
    problem.setMessage(message);
    problem.setItemType("Error");
    logger.processItem(problem);
    
    if(displayProblem) GenLib.displayError(methodID, message);
}    
public void processException(String methodID,
        String message, Exception ex) {
            
    Problem problem = new Problem();
    problem.setMethodID(methodID);
    problem.setMessage(message);
    problem.setException(ex);
    problem.setItemType("Exception");
    logger.processItem(problem);
    
    if(displayProblem) GenLib.displayException(methodID, message, ex);    
}            
//---------- Properties ----------------------------------
//----- displayProblem
public void setDisplayProblem(boolean displayProblem) {
    this.displayProblem = displayProblem;   
}    
public boolean isDisplayProblem() {
    return displayProblem;   
}
//----- markerClass
public void setMarkerClass(String markerClass) {
    logger.setMarkerClass(markerClass);
}                  
public String getMarkerClass() {
    return logger.getMarkerClass();
}                      
//----- resource
public void setResource(String resource) {
    logger.setResource(resource);
}                            
public String getResource() {
    return logger.getResource();
}   
//---------- Public Methods ------------------------------
public void hookupToGenLib() {
    GenLib.setProblemController(this);    
} 
//---------- Private Methods -----------------------------
//--- Std
private static void print(String text) {
    System.out.println("ProblemHandler" + text);
}

} // End class
