package org.jcon.util.log;

import org.jcon.util.DataLib;
import org.jcon.util.GenLib;
import org.jcon.param.Param; 
import org.jcon.param.StringVector;
                                   
/**
 * This class represents a "problem" when needs attention
 * and logging. This allows various systems to pass
 * incidents into this subsystem easily and uniformly.
 *
 * @author Jack Harich
 */
public class Problem implements LogItem {

//---------- Private Fields ------------------------------ 
private boolean isDisplay = true;
private String sourceID; // UserID
private String methodID;
private String itemType; 
private String dateTime;
private String message;
private Exception exception; // null if none
    
  /**@shapeType DependencyLink
@label processes*/
  /*#  Logger lnkUnnamed*/
//---------- Initialization ------------------------------
public Problem() {
    dateTime = GenLib.createCurrentDateTime();
}
//---------- LogItem Implementation ----------------------                    
public boolean isDisplay() {
    return isDisplay;
}                     
public String getSourceID() {
    return sourceID;
}                       
public String getMethodID() {
    return methodID;
}      
public String getItemType() {                                              
    return itemType;
}                          
public String getMessage() {
    return message;
} 
public String getProblem() {
    if (exception == null) {
        return null;
    } else {
        return DataLib.convertStackTraceToString(exception);  
    }
} 
public Exception getException() {
    return exception;    
}
public String getDateTime() {
    return dateTime;
} 
// Not a full state representation ***
public String toString() { 
    String text = itemType + ", " + methodID +
        ", " + dateTime + "\n" + message;
    if (exception != null) text += "\n" + getProblem();
    return text;
}
//---------- Properties ----------------------------------  
public void setDisplay(boolean display) {
    isDisplay = display;
}    
public void setSourceID(String sourceID) {
    this.sourceID = sourceID;
} 
public void setMethodID(String methodID) {
    this. methodID= methodID;
} 
public void setItemType(String itemType) {
    this.itemType = itemType;
}
public void setMessage(String message) {
    this. message= message;
} 
/**
* Sets the Exception if any, that caused the incident.
*/                                   
public void setException(Exception exception) {
    this.exception = exception;
}
//---------- Public Methods ------------------------------

//---------- Private Methods -----------------------------   
//--- Std
private static void print(String text) {
    System.out.println("Incident" + text);
}

} // End class






















