package org.jcon.util.log; 
                            
import org.jcon.io.TextResource;
import org.jcon.util.GenLib;
     
/**
* This class receives LogItems and processes them, 
* including logging for future analysis. Later we
* may add the ability to forward the item to the
* server and process it there.
*
* @author Jack Harich
*/ 
public class Logger { 

//---------- Private Fields ------------------------------
private TextResource textResource = new TextResource();
private boolean displayItems;
private String  markerClass;

private static final String SEPARATOR = "----------"; 
                                                         
//---------- Properties ----------------------------------
//----- displayItem 
/**
* If true then LogItems that return true for isDisplay()
* will be displayed. The default is false.
*/
public void setDisplayItems(boolean display) {
    this.displayItems = display;
}                                  
public boolean isDisplayItems() {
    return displayItems;
}
//----- markerClass
public void setMarkerClass(String markerClass) {
    this.markerClass = markerClass;
    textResource.setMarker(GenLib.createInstance(markerClass));
}                  
public String getMarkerClass() {
    return markerClass;
}                      
//----- resource
public void setResource(String resource) {
    textResource.setResource(resource);
}                            
public String getResource() {
    return textResource.getResource();
}
//---------- Public Methods ------------------------------
/**
* This processes the item according to the logs's properties.
* Currently this is adding it to a file and displaying the
* item if it should be displayed.
*/ 
public synchronized void processItem(LogItem item) {
    //----- Store item
    String text;
    if (! textResource.exists()) {
        text = getLogText(item);
        
    } else if (textResource.isEmpty()) {
        text = getLogText(item);
        
    } else {
        text = SEPARATOR + "\n" + getLogText(item);
    }
    textResource.appendString(text); 
     
    //----- Display item - IMPROVE LATER
    if (item.isDisplay() && displayItems) {
        if (item.getException() == null) {
            GenLib.displayError(item.getMethodID(), item.getMessage());
        } else {
            GenLib.displayException(item.getMethodID(),
                item.getMessage(), item.getException());
        }
    }
} 
/*
* This empties the log, which should be done after reviewing it.
*/
public synchronized boolean emptyLog() {
    return textResource.empty();  
} 
/**
* This returns an array of all the items in the log.
* This is useful for a visual review of the log.
*/
public synchronized String[] listItems() {
    return textResource.readStringArray(SEPARATOR);
}
//---------- Private Methods -----------------------------
private String getLogText(LogItem item) {
    String text =
        item.getItemType() + ", " +
        item.getMethodID() + ", " +
        item.getDateTime() + "\n" + 
        item.getMessage();
    if (item.getProblem() != null) text += "\n" + item.getProblem();
    return text;    
}
//--- Std
private static void print(String text) {
    System.out.println("Logger" + text);
}

} // End class






















