package org.jcon.util.log; 
            
/**
* This interface represents an item such as an exception
* that needs logging. It may be displayed also.
*/
public interface LogItem extends java.io.Serializable {
 
/**
* Returns true if this item should be displayed to the
* user as soon as possible. This allows test, security,
* monitor items and such to not be displayed. It also
* allows server items to not be initially displayed.
*/   
public boolean isDisplay(); 
                            
/**
* This returns text identifying the machine source, such
* as the UserID and IP machine name. It may be null.
*/
public String getSourceID();

/**
* Returns the "ClassName.methodName()" originating the
* items, such as where the exception occurred. May be null.
*/          
public String getMethodID();

/**
* Returns the item type, such as "Exception", "Error",
* "Test25", etc. This should NOT be null.
*/
public String getItemType();
 

/**
* Returns the text describing the item. This may contain
* new line charcters. This should NOT be null.
*/
public String getMessage();

/**
* Returns the text describing the problem, such as an
* Exception stack trace. This should be null if none.
*/
public String getProblem();

/**
* Returns the exception, if any, causing the problem.
* This should be null if none.
*/
public Exception getException();

/**
* Returns the formatted date and time the item occurred.
* The format must be "MM/DD/YY HH:MM:SS", which is in GenLib.
* This should NOT be null.
*/
public String getDateTime(); 
                         
/**
* Returns a simple text representation of the entire
* item's state. For simplicity we may use this initially
* when logging.
*/
public String toString();
 

} // End interface














