package org.jcon.util.lock;

import org.jcon.ui.ColorBar;
import java.awt.*;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;

/**
 * Contains the view components for a client using the LockPool.
 *
 * @author Jack Harich
 */
public class TestViewClient {

//---------- Private Fields ------------------------------
private ActionListener controller;
private Panel     mainPanel = new Panel();

private TextField namesFld  = new TextField(15);
private Button    startBtn  = new Button("Start");
private TextField statusFld = new TextField(8);
private ColorBar  colorBar  = new ColorBar();

private String name;

// For status
private boolean working;
private int     waitCount;

//---------- Initialization ------------------------------
public TestViewClient(String name) {
    this.name = name;
    startBtn.setActionCommand(name);

    colorBar.setCellCount(10); // To reserve space for 10
    colorBar.setBlinkRate(500);

    statusFld.setEditable(false);

    mainPanel.add(namesFld);
    mainPanel.add(startBtn);
    mainPanel.add(statusFld);
    mainPanel.add(colorBar);
}
//---------- Properties ----------------------------------
public String getName() {
    return name;
}
// Required for button listener
public void setController(ActionListener controller) {
    this.controller = controller;
    startBtn.addActionListener(controller);
}
public Component getComponent() {
    return (Component)mainPanel;
}
public void setStatus(String text) {
    statusFld.setText(text);
}
public ColorBar getColorBar() {
    return colorBar;
}
public void setCellCount(int count) {
    colorBar.setCellCount(count);
}
// Show cyan in status field if waiting
public void setWaiting(boolean waiting) {
    Color color = (waiting ? Color.cyan : Color.lightGray);
    statusFld.setBackground(color);
}
//----- Object names
public void setObjectNames(String names) {
    namesFld.setText(names);
}
public String[] getObjectNames() {
    String names = namesFld.getText().toUpperCase();
    return convertDelimStringToArray(names, ", ");
}
//----- Status related
public void setWorking(boolean working) {
    this.working = working;
    refreshStatus();
}
//---------- Public Methods ------------------------------
public void refreshCellCount() {
    String[] names = getObjectNames();
    colorBar.setCellCount(names.length);
}
public void changeWaitCount(int change) {
    waitCount += change;
    refreshStatus();
}
//---------- Private Methods -----------------------------
private void refreshStatus() {
    setWaiting(waitCount > 0 ? true : false);
    if (waitCount > 0) {
        setWaiting(true);
        setStatus(waitCount + " waiting");
    } else {
        setWaiting(false);
        setStatus(working ? "working" : "idle");
    }
}
/**
 * Builds and returns a String array from the delimItems
 * using the delimters. A SringTokenizer is
 * constructed with (delimItems, delimeters), so the
 * arguments should adhere to those expectations.
 * <p>
 * From DataLib to reduce coupling.
 */
private static String[] convertDelimStringToArray(
        String delimItems, String delimiters) {

    StringTokenizer tokens = new StringTokenizer(delimItems, delimiters);
    String[] items = new String[tokens.countTokens()];
    int i = 0;
    while (tokens.hasMoreTokens()) {
        items[i] = tokens.nextToken();
        i++;
    }
    return items;
}
//--- Std
private static void print(String text) {
    System.out.println("TestViewClient" + text);
}

} // End class
